<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class CVDataSeeder extends Seeder
{
    public function run()
    {
        // Insert Biodata
        $this->db->table('biodata')->insert([
            'nama_lengkap' => 'Putri Anggriyani',
            'email' => 'putrianggriyani354@gmail.com',
            'no_telepon' => '+62 812-1070-0662',
            'alamat' => '',
            'tanggal_lahir' => null,
            'tentang_saya' => 'Mahasiswa Ilmu Komputer berpengalaman dalam pengembangan web (front-end: HTML, CSS, JavaScript; back-end: PHP, Laravel) dan pengembangan mobile (Kotlin dasar). Memiliki pengalaman sebagai tenaga pendidik dan administrator, dengan keterampilan dokumentasi teknis menggunakan Microsoft Office (Word, Excel, PowerPoint). Aktif mengikuti perkembangan teknologi modern, tertarik berkontribusi di bidang Web Development, Mobile development, Data Science, dan Data Analysis.',
            'keahlian' => 'HTML, CSS, JavaScript, PHP, Python, Laravel, Kotlin (dasar), MySQL, SQLite, Machine Learning (Dasar), Generative AI, Prompt AI, Git, GitHub, VS Code, XAMPP, Microsoft Office, Canva, Android Studio',
            'linkedin' => 'https://linkedin.com/in/putri-anggriyani-pay',
            'github' => null,
            'website' => '',
            'foto_profil' => null,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
        ]);

        // Insert Education
        $educationData = [
            [
                'nama_sekolah' => 'Universitas Yatsi Madani',
                'jurusan' => 'Ilmu Komputer',
                'jenjang' => 'S1',
                'tahun_mulai' => '2023',
                'tahun_selesai' => null,
                'nilai_akhir' => '3.81',
                'deskripsi' => 'Semester 4 dengan IPK: 3.81 / 4.00. Fokus pada pengembangan web dan mobile, serta eksplorasi teknologi AI modern.',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('education')->insertBatch($educationData);

        // Insert Work Experience
        $workData = [
            [
                'nama_perusahaan' => 'SDIT AL-HIKMAH',
                'posisi' => 'Guru',
                'tahun_mulai' => '2023',
                'tahun_selesai' => '2025',
                'deskripsi' => 'Menyusun dan menyampaikan RPP untuk siswa SD. Meningkatkan keterlibatan kelas dan hasil belajar. Membimbing siswa dalam kegiatan akademik dan non-akademik (ekstrakurikuler, lomba, dll.). Berkomunikasi efektif dengan orang tua/wali murid mengenai perkembangan siswa. Mengelola kelas dengan pendekatan disiplin positif dan inklusif. Menggunakan teknologi pendidikan untuk mendukung pembelajaran (e-learning, media digital, dll).',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_perusahaan' => 'KOMINFO',
                'posisi' => 'Public Relations Intern',
                'tahun_mulai' => '2024',
                'tahun_selesai' => '2024',
                'deskripsi' => 'Membantu dalam menyusun, mengolah, dan menyebarluaskan informasi terkait program kerja pemerintah daerah. Mengelola media sosial KIM untuk meningkatkan aksesibilitas informasi kepada masyarakat. Berkontribusi dalam pelaksanaan kegiatan penyuluhan kepada masyarakat terkait literasi digital dan pemanfaatan teknologi informasi. Membuat dan melaksanakan program kerja digitalisasi untuk masyarakat.',
                'urutan' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_perusahaan' => 'Store Retail',
                'posisi' => 'Cashier',
                'tahun_mulai' => '2022',
                'tahun_selesai' => '2023',
                'deskripsi' => 'Melayani transaksi pembayaran tunai/non-tunai (debit, QRIS, e-wallet) dengan cepat dan akurat. Mengoperasikan mesin kasir (POS system) dan memastikan laporan keuangan harian sesuai. Mengecek stok barang, memastikan display produk rapi, dan membantu restock. Memberikan pelayanan ramah, menjawab pertanyaan pelanggan, serta merekomendasikan produk. Membantu pembersihan dan penataan toko agar nyaman bagi pelanggan. Melakukan tutup kasir (closing) dan rekonsiliasi pendapatan harian.',
                'urutan' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_perusahaan' => 'Laodra Laundry',
                'posisi' => 'Cashier Administration',
                'tahun_mulai' => '2021',
                'tahun_selesai' => '2022',
                'deskripsi' => 'Meningkatkan efisiensi pelacakan pesanan hingga 30%. Melayani transaksi, pencatatan pesanan, dan pembayaran. Memberikan informasi layanan & penanganan komplain. Mengelola administrasi dan laporan keuangan harian. Memastikan proses laundry sesuai jadwal. Menjaga kerapian area pelayanan.',
                'urutan' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('work_experience')->insertBatch($workData);

        // Insert Projects
        $projectsData = [
            [
                'nama_project' => 'Website Digital Banking',
                'teknologi' => 'Laravel, PHP, SQL, MySQL',
                'jenis_project' => 'Web',
                'tahun' => '2024',
                'deskripsi' => 'Website perbankan yang menampilkan fitur-fitur layanan seperti tampilan saldo, transfer, pembayaran merchant dsb.',
                'link_project' => '',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_project' => 'Tempat Sampah Otomatis Organik dan Non-Organik',
                'teknologi' => 'Machine Learning, ESP32 cam, sensor IR',
                'jenis_project' => 'Lainnya',
                'tahun' => '2024',
                'deskripsi' => 'Sistem klasifikasi untuk membedakan sampah kategori organik & non-organik. Membuat prototype tempat sampah dari bahan daur ulang dan menempatkan sistem tersebut.',
                'link_project' => '',
                'urutan' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_project' => 'Website Portofolio',
                'teknologi' => 'HTML, CSS, JS',
                'jenis_project' => 'Web',
                'tahun' => '2024',
                'deskripsi' => 'Portofolio responsif yang menampilkan halaman profil, project, & contact.',
                'link_project' => '',
                'urutan' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_project' => 'Aplikasi Mobile CV',
                'teknologi' => 'Android Studio',
                'jenis_project' => 'Mobile',
                'tahun' => '2024',
                'deskripsi' => 'Aplikasi Mobile Android dengan tampilan warna pink-peach sakura yang menampilkan halaman Profil, Kegiatan, & Pendidikan. Responsif, dengan tampilan tautan aktif pada halaman tertentu (Github, linkedln, instagram).',
                'link_project' => '',
                'urutan' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('projects')->insertBatch($projectsData);

        // Insert Organizations
        $organizationsData = [
            [
                'nama_organisasi' => 'HIMAKOM (Himpunan Mahasiswa Ilmu Komputer)',
                'jabatan' => 'Anggota Divisi Akademik',
                'tahun_mulai' => '2025',
                'tahun_selesai' => null,
                'deskripsi' => 'Membantu monitoring perkembangan akademik anggota serta menyusun laporan evaluasi. Mengkoordinasi pelaksanaan sesi diskusi, workshop, dan kelas pengayaan setiap bulan.',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('organizations')->insertBatch($organizationsData);

        // Insert Training/Certificates
        $trainingData = [
            [
                'nama_pelatihan' => 'PR Intern KOMINFO',
                'penyelenggara' => 'KOMINFO',
                'tanggal_mulai' => '2024-10-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: Berita Edukasi Siber Sosial Terkini',
                'sertifikat' => '',
                'urutan' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'AI',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: Belajar Dasar AI | AI Praktis untuk Produktivitas | Belajar Penggunaan Generative AI',
                'sertifikat' => '',
                'urutan' => 2,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Python',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: Memulai Pemrograman dengan Python',
                'sertifikat' => '',
                'urutan' => 3,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Data & Visual Data',
                'penyelenggara' => 'Dicoding Indonesia',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: Belajar Data Science | Belajar Dasar Visualisasi Data | Belajar Dasar Structured Query Language (SQL)',
                'sertifikat' => '',
                'urutan' => 4,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Data Science',
                'penyelenggara' => 'DQLab Academy',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: R Fundamental for Data Science | Python Fundamental for Data Science | Fundamental SQL Using SELECT Statement',
                'sertifikat' => '',
                'urutan' => 5,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'Matlab',
                'penyelenggara' => 'MathWorks',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: MATLAB Onramp | Control Design Onramp with Simulink',
                'sertifikat' => '',
                'urutan' => 6,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_pelatihan' => 'FORTECHBI',
                'penyelenggara' => 'HIMAKOM',
                'tanggal_mulai' => '2024-01-01',
                'tanggal_selesai' => '2024-12-31',
                'deskripsi' => 'Modul: ML & AI | Studi Kasus Aplikasi AI di Pendidikan | Etika dan Pemanfaatan AI',
                'sertifikat' => '',
                'urutan' => 7,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('training')->insertBatch($trainingData);

        // Insert Skills as Activities
        $skillsData = [
            [
                'nama_aktivitas' => 'Hard Skills - Perangkat Lunak',
                'tanggal' => date('Y-m-d'),
                'jam' => '08:00:00',
                'deskripsi' => 'Git, GitHub, VS Code, XAMPP, Microsoft Office, Canva, Android Studio',
                'foto' => '',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_aktivitas' => 'Hard Skills - Bahasa Pemrograman & Framework',
                'tanggal' => date('Y-m-d'),
                'jam' => '09:00:00',
                'deskripsi' => 'HTML, CSS, JavaScript, PHP, Python, Laravel, Kotlin (dasar)',
                'foto' => '',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_aktivitas' => 'Hard Skills - Lainnya',
                'tanggal' => date('Y-m-d'),
                'jam' => '10:00:00',
                'deskripsi' => 'MySQL, SQLite, Machine Learning (Dasar), Generative AI, Prompt AI',
                'foto' => '',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ],
            [
                'nama_aktivitas' => 'Soft Skills',
                'tanggal' => date('Y-m-d'),
                'jam' => '11:00:00',
                'deskripsi' => 'Problem Solving, Komunikasi, Teamwork, Time Management, Fleksibility dan Adaptability',
                'foto' => '',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s')
            ]
        ];
        $this->db->table('activities')->insertBatch($skillsData);
    }
}